<!doctype html>
<html lang="zxx">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- Links of CSS files -->
        <link rel="stylesheet" href="assets/css/bootstrap.min.css">
        <link rel="stylesheet" href="assets/css/animate.min.css">
        <link rel="stylesheet" href="assets/css/meanmenu.min.css">
        <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
        <link rel="stylesheet" href="assets/css/odometer.min.css">
        <link rel="stylesheet" href="assets/css/showMoreItems-theme.min.css">
        <link rel="stylesheet" href="assets/css/owl.carousel.min.css">
        <link rel="stylesheet" href="assets/css/owl.theme.default.min.css">
        <link rel="stylesheet" href="assets/css/remixicon.css">
        <link rel="stylesheet" href="assets/css/style.css">
        <link rel="stylesheet" href="assets/css/responsive.css">

        <title>Isalpi</title>

        <link rel="icon" type="image/png" href="assets/img/isalpi_favicon.png">
    </head>
    <body>

        <!-- Start Navbar Area -->
        <div class="navbar-area navbar-style-three">
            <div class="enry-responsive-nav">
                <div class="container">
                    <div class="enry-responsive-menu">
                        <div class="logo">
                            <a href="index-3.html"><img src="assets/img/ISALPI Logo.png" alt="logo"></a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="enry-nav">
                <div class="container">
                    <nav class="navbar navbar-expand-md navbar-light">
                        <a class="navbar-brand" href="index-3.html"><img src="assets/img/ISALPI Logo.png" alt="logo"></a>

                        <div class="collapse navbar-collapse mean-menu">
                            <ul class="navbar-nav">
                                <li class="nav-item"><a href="#home" class="nav-link active">Home</a></li>

                                <li class="nav-item"><a href="#about" class="nav-link">About Us</a></li>

                                <li class="nav-item"><a href="#services" class="nav-link">Services</a></li>
                                
                                <li class="nav-item"><a href="#blog" class="nav-link">Blog</a></li>

                                <li class="nav-item"><a href="#contact" class="nav-link">Contact</a></li>
                            </ul>


                        </div>
                    </nav>
                </div>
            </div>
        </div>
        <!-- End Navbar Area -->

        <!-- Search Overlay -->
        <!-- End Search Overlay -->

        <!-- Start Banner Area -->
        <div class="banner-area" id="home">
            <div class="container">
              <div class="row align-items-center">
                  <div class="col-lg-6 col-md-12">
                      <div class="banner-content">
                           <?php
                            $Msg = "";
                            if(isset($_GET['error']))
                            {
                                $Msg = " Please Fill in the Blanks ";
                                echo '<div class="alert alert-danger">'.$Msg.'</div>';
                            }

                            if(isset($_GET['success']))
                            {
                                $Msg = " Your Message Has Been Sent ";
                                echo '<div class="alert alert-success">'.$Msg.'</div>';
                            }

                        ?>
                          <span class="sub-title">WE ARE ISALPI</span>
                          <h1>Helping You Adapt&nbsp; Your Services</h1>
                          <p>Our customers seek to adapt their services to meet impacting disruptions.&nbsp; &nbsp; &nbsp;</p>
                        </div>
                  </div>

                  <div class="col-lg-6 col-md-12">
                      <div class="banner-image">
                          <img src="assets/img/Service.png" alt="image">
                      </div>
                  </div>
              </div>
            </div>
        </div>
        <!-- End Banner Area -->
        <!-- End Partner Area -->

        <!-- Start About Area -->
        <div class="about-area ptb-100" id="about">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-md-12">
                        <div class="">
                            <img src="assets/img/about3.jpg" alt="image">
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
                        <div class="about-content">
                            <span class="sub-title">ABOUT ALL OF US</span>
                            <h2>What Will You Get From Our Dedicated Company</h2>
                            <p>ISALPI was incorporated in 1993 by our founder and President Philippe Beaudry. For over 25 years our mission has been help organizations design and develop customer- focused services that were intergrated with integrated with their enterprise's architecture.</p>

<p>Starting initially with helping outsourcing companies develop services that were cost efficient and providing excellent customer experience and support, our clients engaged us in helping them build their own internal services to rival with those being provided by other vendors. This led to numerous engagements related to architecting services and the whole organization itself.</p>

<p>Given the recent nature of technological, social and health disruptions affecting organizations in all industries, our clients are now looking for us to guide them in the adaptation of their services to meet and lead these disruptions.</p>

<p>Our clients have recognized the value of our methodology for dealing with adaptation of services and have enquired as to approach to the workshops we use in our service delivery. While applying the adaptation model to ourselves. We've recently developed a workshop facilitation product, including the necessary training and coaching capabilities to develop their own internal facilitators. Our head office is in Ottawa but have long promoted a virtual office model where our staff can effectively deliver our products and services to clients worldwide.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End About Area -->

        <!-- Start Services Area -->
        <div class="services-area ptb-100 bg-fbf9f7" id="services">
            <div class="container">
                <div class="section-title">
                    <span class="sub-title">SERVICES</span>
                    <h2>Our Services At a Glance</h2>
                </div>
                <div class="row justify-content-center">
                  <div class="col-lg-4 col-md-6">
                    <div class="single-services-item"><img src="assets/img/services/Workshops.png" alt="" width="" height="">

                      <h3>Workshops</h3>
                      <p>Our experienced facilitators have successful, proven processes and tools for running collaborative sessions geared to any kind of meeting including strategic planning, problem-solving, decision-making and team alignment.</p>
                    </div>
                  </div>
                  <div class="col-lg-4 col-md-6">
                    <div class="single-services-item"><img src="assets/img/services/Adaptation.png" alt="" width="" height="">
                      <h3>Service Adaptation&nbsp;</h3>
                      <p>Our experienced service architects have successful, proven methodologies to adapt&nbsp; services to organizational, technological, social and health related disruptions.</p>
                      <p>&nbsp;</p>
                    </div>
                  </div>
                </div>


                </div>
        </div>
        <!-- End Services Area -->
        
          <div class="blog-area ptb-100 bg-fbf9f7" id="blog">
            <div class="container">
                <div class="section-title">
                    <span class="sub-title">Our Recent Blog Posts</span>
                    <h2>Read Up On Our Latest News</h2>
                    <p>Click here to view all of our blog posts.</p>
                </div>
                
            <!-- Uncomment the owl-carousel div once you have more that three blog posts in this row -- !>
            <!--  <div class="blog-slides owl-carousel owl-theme"> -->
            <div class="row justify-content-center">
              <div class="col-lg-4 col-md-6">
                  <div class="single-blog-post">
                      <div class="post-image">
                          <a href="#" class="d-block">
                              <img src="assets/img/blog.jpg" alt="image" width="415.99px">
                          </a>
                      </div>
                      <div class="post-content">
                          <ul class="meta">
                              <li><i class="ri-calendar-2-line"></i> September 14, 2021</li>
                              <li><i class="ri-user-voice-line"></i> <a href="#">Anonymous</a></li>
                          </ul>
                          <h3><a href="blog-details.html">Coming soon</a></h3>
                          <p>New blog coming soon.</p>
                          <a href="#" class="default-btn">Read More <i class="ri-arrow-right-line"></i></a>
                      </div>
                  </div>
              </div>
            </div>

          <!--      </div> -->
            </div>
        </div>
        <!-- End Blog Area -->
        
        <!-- Start Free Quote Area -->
        <div class="free-quote-area pb-100 bg-fbf9f7" id="contact">
            <div class="container">
                <div class="free-quote-inner">
                    <div class="section-title">
                        <span class="sub-title">Contact Us</span>
                        <h2>Looking for Additional Information?</h2>
                    </div>
                    <form action="process.php" method="post">
                        <div class="row">
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label>Your Name</label>
                                    <input type="text" class="form-control" name="Name">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label>Your Email</label>
                                    <input type="text" class="form-control" name="Email">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label>Request</label>
                                    <textarea id="index_textarea" name="Message" id="message" rows="8" cols="80" style="background-color: transparent !important; color: white; padding-left: 15px; padding-top: 20px; border: 1px solid #cccccc !important"></textarea>
                                </div>
                            </div>
                            <br>

                              <div class="form-group">
                                  <button type="submit" class="default-btn" name="submit-btn">Request More Information <i class="ri-arrow-right-line"></i></button>
                              </div>


                        </div>
                    </form>
                    <div class="shape6"><img src="assets/img/shape/shape11.png" alt="image"></div>
                    <div class="shape7"><img src="assets/img/shape/shape12.png" alt="image"></div>
                </div>
            </div>
        </div>
        <!-- End Free Quote Area -->
        <!-- Start Footer Area -->
        <footer class="footer-area style-two">
            <div class="container">
                <div class="row  justify-content-center" id="container1">
                    <div class="col-lg-3 col-sm-6 col-md-6">
                        <div class="single-footer-widget text-align-center-2">
                            <a href="index.html" class="logo">
                                <img src="assets/img/ISALPI Logo.png" alt="image">
                            </a>
                            <div class="footer-contact-info">
                                <h5>Contact:</h5>
                                <ul>
                                    <li><span>Call:</span> <a href="tel:+(1)8144822296">+(1) 819-307-1908</a></li>
                                    <li><span>Email:</span> <a href="mailto:info@isalpi.com">info@isalpi.com</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6 col-md-6">
                        <div class="single-footer-widget pl-4 text-align-center-2">
                            <h3>Quick Links</h3>
                            <ul class="links-list">
                                <li><a href="#about">About Us</a></li>
                                <li><a href="#services">Services</a></li>
                                <li><a href="#contact">Contact</a></li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6 col-md-6">
                        <div class="single-footer-widget">
                            <h3 class="text-align-center-2">Opening Hours</h3>
                            <ul class="opening-hours">
                                <li>SUN - MON: <span>8:00 AM - 9:00 PM</span></li>
                                <li>TUE: <span>8:00 AM - 9:00 PM</span></li>
                                <li>WED: <span>8:00 AM - 9:00 PM</span></li>
                                <li>THU: <span>8:00 AM - 9:00 PM</span></li>
                                <li>FRI-SAT: <span>Closed</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="copyright-area">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-7 col-sm-6">
                            <p>Copyright @2021 Le Groupe Réseau ISALPI Inc.</p>
                        </div>

                        <div class="col-lg-6 col-md-5 col-sm-6">
                            <ul class="social-links">
                                <li><a href="https://www.facebook.com/Isalpi-106556138439310" target="_blank"><i class="ri-facebook-fill"></i></a></li>
                                <li><a href="https://twitter.com/isalpicorp" target="_blank"><i class="ri-twitter-fill"></i></a></li>
                                <li><a href="https://www.linkedin.com/company/isalpi" target="_blank"><i class="ri-linkedin-fill"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        <!-- End Footer Area -->

        <div class="go-top"><i class="ri-arrow-up-s-line"></i></div>

        <!-- Links of JS files -->
        <script src="assets/js/jquery.min.js"></script>
        <script src="assets/js/bootstrap.bundle.min.js"></script>
        <script src="assets/js/owl.carousel.min.js"></script>
        <script src="assets/js/appear.min.js"></script>
        <script src="assets/js/odometer.min.js"></script>
        <script src="assets/js/magnific-popup.min.js"></script>
        <script src="assets/js/mixitup.min.js"></script>
        <script src="assets/js/meanmenu.min.js"></script>
        <script src="assets/js/showMoreItems.min.js"></script>
        <script src="assets/js/wow.min.js"></script>
        <script src="assets/js/form-validator.min.js"></script>
        <script src="assets/js/contact-form-script.js"></script>
        <script src="assets/js/ajaxchimp.min.js"></script>
        <script src="assets/js/main.js"></script>
    </body>
</html>
